/*
 * Decompiled with CFR 0.152.
 */
package compasses.expandedstorage.forge.misc;

import compasses.expandedstorage.forge.misc.ClientboundUpdateRecipesMessage;
import compasses.expandedstorage.impl.inventory.ServerScreenHandlerFactory;
import compasses.expandedstorage.impl.inventory.handler.AbstractHandler;
import compasses.expandedstorage.impl.misc.CommonPlatformHelper;
import compasses.expandedstorage.impl.misc.Utils;
import compasses.expandedstorage.impl.recipe.BlockConversionRecipe;
import compasses.expandedstorage.impl.recipe.EntityConversionRecipe;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.Nullable;

public class ForgeCommonHelper
implements CommonPlatformHelper {
    private final SimpleChannel channel = NetworkRegistry.newSimpleChannel((ResourceLocation)Utils.id("channel"), () -> "1.0", "1.0"::equals, "1.0"::equals);
    private final MenuType<AbstractHandler> menuType;

    public ForgeCommonHelper() {
        this.channel.registerMessage(0, ClientboundUpdateRecipesMessage.class, ClientboundUpdateRecipesMessage::encode, ClientboundUpdateRecipesMessage::decode, ClientboundUpdateRecipesMessage::handle);
        this.menuType = new MenuType((MenuType.MenuSupplier)((IContainerFactory)AbstractHandler::createClientMenu), FeatureFlags.f_244377_);
    }

    @Override
    public MenuType<AbstractHandler> getScreenHandlerType() {
        return this.menuType;
    }

    @Override
    public void openScreenHandler(ServerPlayer player, final Container inventory, final ServerScreenHandlerFactory factory, final Component title, ResourceLocation forcedScreenType) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return title;
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
                return factory.create(syncId, inventory, playerInventory);
            }
        }, buffer -> {
            buffer.writeInt(inventory.m_6643_());
            if (forcedScreenType != null) {
                buffer.m_130085_(forcedScreenType);
            }
        });
    }

    @Override
    public void sendConversionRecipesToClient(@Nullable ServerPlayer target, List<BlockConversionRecipe<?>> blockRecipes, List<EntityConversionRecipe<?>> entityRecipes) {
        if (target == null) {
            this.channel.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundUpdateRecipesMessage(blockRecipes, entityRecipes));
        } else if (!this.channel.isRemotePresent(target.f_8906_.f_9742_)) {
            target.f_8906_.m_9942_((Component)Component.m_237115_((String)"text.expandedstorage.disconnect.old_version"));
        } else {
            this.channel.send(PacketDistributor.PLAYER.with(() -> target), (Object)new ClientboundUpdateRecipesMessage(blockRecipes, entityRecipes));
        }
    }

    @Override
    public boolean canDestroyBamboo(ItemStack stack) {
        return stack.canPerformAction(ToolActions.SWORD_DIG);
    }
}

